﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;
using CashierCrisis.Managers;
using Microsoft.Xna.Framework.Media;

namespace CashierCrisis.Scenes
{
    // This is the main menu scene.
    public class MainMenuScene : Scene
    {
        public MainMenuScene(Game game)
            : base(game)
        {
        }

        Texture2D menuBackgroundTexture;
        Song song;

        public override void LoadContent()
        {
            menuBackgroundTexture = Content.Load<Texture2D>("Sprites\\Title");
            AudioManager.LoadMusicContent(Content, "Audio\\Music\\MenuMedley", "Menu");
           song = AudioManager.PlayMusic("Menu");
           MediaPlayer.IsRepeating = true;
            base.LoadContent();
        }

        public override void Draw(SpriteBatch spriteBatch)
        {
            spriteBatch.Draw(menuBackgroundTexture, SceneManager.ScreenRectangle, Color.White);
            base.Draw(spriteBatch);
        }

        public override void UnloadContent()
        {
            MediaPlayer.Stop();
        }

    
    }
}
